let sound;
let health = 0.1;
let level = -2;
let playMode = 'sustain';
let scoreCount = 0;     // All the variables i need for my code to work

function preload() {
  sound = loadSound('Sounds/Jump.wav');
  GameOver = loadSound('Sounds/GameOver.wav');
  BG = loadImage('Images/Menu.jpg');
  Dead = loadImage('Images/Dead.jpg');
  CoinNoise = loadSound('Sounds/CoinNoise.wav');
  MenuMusic = loadSound('Sounds/MenuMusic.mp3');
  PressM = loadImage('Images/PressM.jpg');
  Thud = loadSound('Sounds/Thud.wav');
  Level1Back = loadImage('Images/Level1Back.jpg');
  Level2Back = loadImage('Images/Level2Back.jpg');
}        // these are all the sounds and images that i need throughout the project

function setup() {
  createCanvas(700, 500);
  background(200);
  user = new User();
  enemy = new Enemy();
  coin = new Coin();
  enemy2 = new Enemy2();
  noStroke();
  rectMode(CENTER);
}         // simple and easy setup function which brings in all my seperate JS files
function draw() {
  background(175);
  switch (level) {
    case -2:
      image(PressM,0,0,700,500);    //Start Screen
      break;
    case -1:
      image(Dead,0,0,700,500);       //Dead screen
      break;

    case 0:
      image(BG,0,0,700,500);         //Home Screen
      break;

    case 1:
      testLevel();       // Level 1 code

      image(Level1Back,0,0,700,500);
      user.show();
      user.update();
      enemy.show();      // bringing in all my assets
      enemy.update();
      enemy.offscreen();
      coin.show();
      var d = dist(user.x, user.y, enemy.x, enemy.y);     // these help me know when the objects colide
      var Collect = dist(user.x,user.y,coin.x,coin.y);
    
      if (keyIsDown(37)) {
        user.left();         //Moves user left
      }
      if (keyIsDown(39)) {
        user.right();       // moves user right
      }
      for (let i = enemy.length - 1; i >= 0; i--) {
        enemy[i].show();
        enemy[i].update();       //spawns the enemy in
    
        if (enemy[i].hits(user)) {
          console.log("HIT");
        }
    
      }
      if (d <= 50) {
        console.log('hit');
        health = health - 1;      //When hits it restarts game
      }
      if (Collect < 30){
        console.log('score');
        coin.x = random(50,650);
        coin.y = random(50,450);      // adds score when coin collected
        CoinNoise.play();
        scoreCount = scoreCount + 1;
      }
      textSize(24);
      textAlign(LEFT,CENTER);      // Score count
      text('Score: ' + scoreCount, 50, 50);

      

      break;

    case 2:               // Level 2, same as 1 but with some minor changes to make it harder
      testLevel();

      image(Level2Back,0,0,700,500);

      user.show();
      user.update();
      enemy.show();
      enemy.update();
      enemy.offscreen();
      enemy2.show();
      enemy2.update();
      enemy2.offscreen();
      coin.show();
      var d = dist(user.x, user.y, enemy.x, enemy.y);
      var d2 = dist(user.x, user.y, enemy2.x, enemy2.y);
      var Collect = dist(user.x,user.y,coin.x,coin.y);

      if (keyIsDown(37)) {
        user.left();
      }
      if (keyIsDown(39)) {
        user.right();
      }

      textSize(24);
      textAlign(LEFT,CENTER);
      text('Score: ' + scoreCount, 50, 50);

      if (d <= 35) {
        console.log('hit');
        health = health - 1;
      }
      if (d2 <= 35) {
        console.log('hit');
        health = health - 1;
      }

      if (Collect < 25){
        console.log('score');
        coin.x = random(50,650);
        coin.y = random(50,450);
        CoinNoise.play();
        scoreCount = scoreCount + 1;
      }
      
      for (let i = enemy.length - 1; i >= 0; i++) {
        enemy[i].show();
        enemy[i].update();
    
        if (enemy[i].hits(user)) {
          console.log("HIT");
        }
      }
      for (let j = enemy2.length + 1; j >= 0; j++) {      // second enemy
        enemy2[j].show();
        enemy2[j].update();
    
        if (enemy2[j].hits(user)) {
          console.log("HIT");
        }
      }


      break;
  }

}


function keyPressed() {      // jump function with jump sound
  if (keyCode === 32) {
    user.up();
    sound.play();
  }
  if (keyCode === 49) {      // Activates level 1
    level = 1;
    health = 1;
    scoreCount = 0;
    console.log("Level1");
    enemy.x = 600;
    enemy2.x = 100;
    user.x = 100;
    user.y = 400;
    enemy.speed = 6;
  }
  if (keyCode === 77){      // Main menu
    level = 0;
  }
  if (keyCode === 50){      // Activates level 2
    level = 2;
    health = 1;
    scoreCount = 0;
    console.log("Level2");
    enemy.x = 600;
    enemy2.x = 100;
    user.x = 100;
    user.y = 400;
    enemy.speed = 10;
    enemy2.speed = -10     // level 2 enemy faster
  }
  if (keyCode === 13){      //Starts game
    level = 0;
    MenuMusic.play();
  }

  clear();
}

function testLevel() {      //Test level to select level
  if (health <= 0) {
    level = -1;
    GameOver.play();
  }
}